/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.casting;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_1074;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import slimeknights.mantle.fluid.tooltip.FluidTooltipHandler;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.library.recipe.casting.IDisplayableCastingRecipe;
import slimeknights.tconstruct.plugin.jei.IRecipeTooltipReplacement;
import slimeknights.tconstruct.plugin.jei.fabric.JEITypes;

public abstract class AbstractCastingCategory
implements IRecipeCategory<IDisplayableCastingRecipe>,
IRecipeTooltipReplacement {
    private static final String KEY_COOLING_TIME = TConstruct.makeTranslationKey("jei", "time");
    private static final String KEY_CAST_KEPT = TConstruct.makeTranslationKey("jei", "casting.cast_kept");
    private static final String KEY_CAST_CONSUMED = TConstruct.makeTranslationKey("jei", "casting.cast_consumed");
    protected static final class_2960 BACKGROUND_LOC = TConstruct.getResource("textures/gui/jei/casting.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable tankOverlay;
    private final IDrawable castConsumed;
    private final IDrawable castKept;
    private final IDrawable block;
    private final LoadingCache<Integer, IDrawableAnimated> cachedArrows;

    protected AbstractCastingCategory(final IGuiHelper guiHelper, class_2248 icon, IDrawable block) {
        this.background = guiHelper.createDrawable(BACKGROUND_LOC, 0, 0, 117, 54);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new class_1799((class_1935)icon));
        this.tankOverlay = guiHelper.createDrawable(BACKGROUND_LOC, 133, 0, 32, 32);
        this.castConsumed = guiHelper.createDrawable(BACKGROUND_LOC, 141, 32, 13, 11);
        this.castKept = guiHelper.createDrawable(BACKGROUND_LOC, 141, 43, 13, 11);
        this.block = block;
        this.cachedArrows = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            public IDrawableAnimated load(Integer coolingTime) {
                return guiHelper.drawableBuilder(BACKGROUND_LOC, 117, 32, 24, 17).buildAnimated(coolingTime.intValue(), IDrawableAnimated.StartDirection.LEFT, false);
            }
        });
    }

    public boolean isHandled(IDisplayableCastingRecipe recipe) {
        return true;
    }

    public void draw(IDisplayableCastingRecipe recipe, IRecipeSlotsView recipeSlotsView, class_332 graphics, double mouseX, double mouseY) {
        ((IDrawableAnimated)this.cachedArrows.getUnchecked((Object)Math.max(1, recipe.getCoolingTime()))).draw(graphics, 58, 18);
        this.block.draw(graphics, 38, 35);
        if (recipe.hasCast()) {
            (recipe.isConsumed() ? this.castConsumed : this.castKept).draw(graphics, 63, 39);
        }
        int coolingTime = recipe.getCoolingTime() / 20;
        String coolingString = class_1074.method_4662((String)KEY_COOLING_TIME, (Object[])new Object[]{coolingTime});
        class_327 fontRenderer = class_310.method_1551().field_1772;
        int x = 72 - fontRenderer.method_1727(coolingString) / 2;
        graphics.method_51433(fontRenderer, coolingString, x, 2, Color.GRAY.getRGB(), false);
    }

    public List<class_2561> getTooltipStrings(IDisplayableCastingRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (recipe.hasCast() && GuiUtil.isHovered((int)mouseX, (int)mouseY, 63, 39, 13, 11)) {
            return Collections.singletonList(class_2561.method_43471((String)(recipe.isConsumed() ? KEY_CAST_CONSUMED : KEY_CAST_KEPT)));
        }
        return Collections.emptyList();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, IDisplayableCastingRecipe recipe, IFocusGroup focuses) {
        List<class_1799> casts = recipe.getCastItems();
        if (!casts.isEmpty()) {
            builder.addSlot(recipe.isConsumed() ? RecipeIngredientRole.INPUT : RecipeIngredientRole.CATALYST, 38, 19).addItemStacks(casts);
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 93, 18).addItemStack(recipe.getOutput());
        long capacity = 81000L;
        builder.addSlot(RecipeIngredientRole.INPUT, 3, 3).addTooltipCallback((IRecipeSlotTooltipCallback)this).setFluidRenderer(capacity, false, 32, 32).setOverlay(this.tankOverlay, 0, 0).addIngredients(JEITypes.FLUID_STACK, recipe.getFluids());
        int h = 11;
        if (!recipe.hasCast()) {
            h += 16;
        }
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 43, 8).addTooltipCallback((IRecipeSlotTooltipCallback)this).setFluidRenderer(1L, false, 6, h).addIngredients(JEITypes.FLUID_STACK, recipe.getFluids());
    }

    @Override
    public void addMiddleLines(IRecipeSlotView slot, List<class_2561> list) {
        slot.getDisplayedIngredient(JEITypes.FLUID_STACK).ifPresent(stack -> FluidTooltipHandler.appendMaterial(stack, list));
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }
}

